/*
	Copyright 1999, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.
*/

#if !defined(GLOBALDATA_H)
#define GLOBALDATA_H

#include "../include/DriverInterface.h"

extern int fd;
extern shared_info *si;
extern area_id shared_info_area;
extern vuint32 *regs;
extern area_id regs_area;
extern area_id iobase_area;
extern vuint32 *iobase;
extern vuint32 *framebuffer;
extern area_id fb_area;
extern display_mode *my_mode_list;
extern area_id my_mode_list_area;
extern int accelerantIsClone;

/* Print debug message through kernel driver. Should move to other location later. */
extern void dpf (const char * format, ...);
extern void outb(uint16 port, uint8 data);
extern void outw(uint16 port, uint16 data);
extern void outl(uint16 port, uint32 data);
extern uint8 inb(uint16 port);
extern uint16 inw(uint16 port);
extern uint32 inl(uint16 port);
#endif
